#ifndef THREAD_SAFE_MALLOC_H
#define THREAD_SAFE_MALLOC_H
#include <stdlib.h> /* size_t */

void tmallocInitialize(void);
void tmallocShutdown(void);

void *tmalloc(size_t size);
void tfree(void *block);
void *tmemcpy(void *dest, const void *src, size_t n);
void *tmemset(void *s, int c, size_t n);
void *tmemxor(void *dst, void *src, size_t n);
void *tmemrnd(void *dst, size_t n);

#endif

