/*
 * Copyright (c) Paul Stankovski
 * Free for all non-commercial use unless this directive conflicts with
 * other applicable copyright statement(s), patent holders, laws or such.
 */
#include "rdtsc.h"

UINT64(*const rdtsc)(void)=(UINT64(*const)(void))"\x0f\x31\xc3";

#ifdef EXAMPLE_OF_USAGE
#include <stdio.h>
#define N 1000000
#define WARMUP_ROUNDS 100
void testRdtsc(void) {
  UINT64 c1, c2;
  long i;
  UINT64 min = 1000000;
  UINT64 tot = 0;
  UINT64 overflow = 0;

  c1 = rdtsc();

  for (i=0; i<WARMUP_ROUNDS+N; i++) {
    UINT64 c3, c4, diff;
    c3 = rdtsc();
    c4 = rdtsc();
    if (i >= WARMUP_ROUNDS) {
      if (c3 < c4) { /* the expected case */
        diff = c4 - c3;
        tot += diff;
        if (diff < min) min = diff;
      }
      else /* overflow */
        overflow++;
    }
  }

  c2 = rdtsc();

  printf("RDTSC test\n\n");

  printf("Start           : %Ld clock cycles\n", c1);
  printf("End             : %Ld clock cycles\n\n", c2);

  printf("External total  : %Ld clock cycles\n", c2 - c1);
  printf("External average: %f clock cycles\n\n", (c2 - c1)/(double)N);

  printf("Internal total  : %Ld clock cycles\n", tot);
  printf("Internal average: %f clock cycles\n", tot/(double)(N - overflow));
  printf("Minimum         : %Ld clock cycles\n", min);
  printf("Overflow        : %d times\n", overflow);
}
#endif

