/*
 * Copyright (c) Paul Stankovski
 * Free for all non-commercial use unless this directive conflicts with
 * other applicable copyright statement(s), patent holders, laws or such.
 */
#include "press_any_key.h"

#ifdef _WIN32
void pressAnyKey(void) { getch(); }
#endif

#ifndef _WIN32
void pressAnyKey(void) { /* TODO - linux implementation (see snippet below) */ }
void kbhit(void) { /* TODO - linux implementation (see snippet below) */ }
int getch(void) { /* TODO - linux implementation (see snippet below) */ return 0; }
#endif

#if 0 /* untested linux version of getch, found on the web */
#include &lt;stdio.h&gt;
#include &lt;termios.h&gt;
#include &lt;term.h&gt;
#include &lt;curses.h&gt;
#include &lt;unistd.h&gt;

static struct termios initial_settings, new_settings;
static int peek_character = -1;

void init_keyboard() {
	tcgetattr(0,&initial_settings);
	new_settings = initial_settings;
	new_settings.c_lflag &= ~ICANON;
	new_settings.c_lflag &= ~ECHO;
	new_settings.c_lflag &= ~ISIG;
	new_settings.c_cc[VMIN] = 1;
	new_settings.c_cc[VTIME] = 0;
	tcsetattr(0, TCSANOW, &new_settings);
	}

void close_keyboard() {
	tcsetattr(0, TCSANOW, &initial_settings);
	}

int kbhit() {
	char ch;
	int nread;

	if (peek_character != -1)
		return 1;
	new_settings.c_cc[VMIN] = 0;
	tcsetattr(0, TCSANOW, &new_settings);
	nread = read(0, &ch, 1);
	new_settings.c_cc[VMIN] = 1;
	tcsetattr(0, TCSANOW, &new_settings);

	if (nread == 1) {
		peek_character = ch;
		return 1;
		}
	return 0;
	}

char readch() {
	char ch;
	if (peek_character != -1) {
		ch = peek_character;
		peek_character = -1;
		return ch;
		}
	read(0, &ch, 1);
	return ch;
	}

Usage:
  if (kbhit())
    readch();
#endif

