/*
 * Copyright (c) Paul Stankovski
 * Free for all non-commercial use unless this directive conflicts with
 * other applicable copyright statement(s), patent holders, laws or such.
 */
#include "memxor.h"
#include "platform_types.h"

void *memxor(void *dst, void *src, size_t n) {
  if (n % 8 == 0) {
    UINT64 *d = (UINT64*)dst;
    UINT64 *s = (UINT64*)src;
    unsigned int i;
    for (i=0; i<n/sizeof(UINT64); i++)
      *d++ ^= *s++;
  } else if (n % 4 == 0) {
    int *d = (int*)dst;
    int *s = (int*)src;
    unsigned int i;
    for (i=0; i<n/sizeof(int); i++)
      *d++ ^= *s++;
  } else {
    BYTE *d = (BYTE*)dst;
    BYTE *s = (BYTE*)src;
    unsigned int i;
    for (i=0; i<n/sizeof(BYTE); i++)
      *d++ ^= *s++;
  }
  return dst;
}

