#ifndef MEMORY_UTILS_H
#define MEMORY_UTILS_H
#include "memory_utils_conf.h"

#if defined(MEMORY_TRACKER_ENABLED)

#include "memory_tracker.h"

#define MALLOC(size)        memoryTrackerMalloc((size), __FILE__, __LINE__)
#define FREE(block)         memoryTrackerFree((block), __FILE__, __LINE__)
#define MEMCPY(dst, src, n) memoryTrackerMemcpy((dst), (src), (n), __FILE__, __LINE__)
#define MEMSET(s, c, n)     memoryTrackerMemset((s), (c), (n), __FILE__, __LINE__)
#define MEMXOR(dst, src, n) memoryTrackerMemxor((dst), (src), (n), __FILE__, __LINE__)
#define MEMRND(dst, n)      memoryTrackerMemrnd((dst), (n), __FILE__, __LINE__)

#define TMALLOC(size)        memoryTrackerTMalloc((size), __FILE__, __LINE__)
#define TFREE(block)         memoryTrackerTFree((block), __FILE__, __LINE__)
#define TMEMCPY(dst, src, n) memoryTrackerTMemcpy((dst), (src), (n), __FILE__, __LINE__)
#define TMEMSET(s, c, n)     memoryTrackerTMemset((s), (c), (n), __FILE__, __LINE__)
#define TMEMXOR(dst, src, n) memoryTrackerTMemxor((dst), (src), (n), __FILE__, __LINE__)
#define TMEMRND(dst, n)      memoryTrackerTMemrnd((dst), (n), __FILE__, __LINE__)

#else

#include <stdlib.h> /* size_t, malloc, free */
#include <string.h> /* memcpy, memset */
#include "memxor.h"
#include "memrnd.h"
#include "tmalloc.h"

#define MALLOC malloc
#define FREE   free
#define MEMSET memset
#define MEMCPY memcpy
#define MEMXOR memxor
#define MEMRND memrnd

#define TMALLOC tmalloc
#define TFREE   tfree
#define TMEMSET tmemset
#define TMEMCPY tmemcpy
#define TMEMXOR tmemxor
#define TMEMRND tmemrnd

#endif

#endif

