#ifndef LOG_UTILS_H
#define LOG_UTILS_H
#include <stdio.h>
#include <time.h>
#include "platform_types.h"

#define LOGSCREEN  1
#define LOGFILE    2
#define LOGFLUSH   4

#define LOGNOFLUSH 3
#define LOGALL     7

void logger(FILE *logFile, int flags, const char *formatString, ...);

void logBuf(FILE *logFile, int flags, const BYTE *buf, int len, int gap, int compactifyLeadingZeros);
void logTimeRaw(FILE *logFile, int flags, time_t start);
void logDateRaw(FILE *logFile, int flags);

#endif

