/*
 * Copyright (c) Paul Stankovski
 * Free for all non-commercial use unless this directive conflicts with
 * other applicable copyright statement(s), patent holders, laws or such.
 */
#include "fill_utils.h"
#include "memory_utils.h"
#include "assert_utils.h"

void bufFill(BYTE *buf, int fill, int numBytes) {
  int i;
  switch (fill) {
  case FILL_ZEROS:
    MEMSET(buf, 0, numBytes);
    break;
  case FILL_ONES:
    MEMSET(buf, 0xFF, numBytes);
    break;
  case FILL_RANDOM:
    for (i=0; i<numBytes; i++)
      buf[i] = (BYTE)(rand() & 0xFF);
    break;
  default:
    ASSERT_ALWAYS("Unexpected fill value!");
  }
}

