/*
 * Copyright (c) Paul Stankovski
 * Free for all non-commercial use unless this directive conflicts with
 * other applicable copyright statement(s), patent holders, laws or such.
 */
#include "black_box_utils.h"
#include <stdio.h>
#include <string.h>

void printManyChar(char ch, int n) {
  int i;
  for (i=0; i<n; i++)
    printf("%c", ch);
}

void stars(int n) {
  printManyChar('*', n);
}

void starHeader(const char *text) {
  const int width = 80;
  const int len = strlen(text);
  const int leftPad = (width - len - 4) / 2;
  const int rightPad = width - len - 4 - leftPad;
  stars(width); printf("\n");
  stars(width); printf("\n");
  printf("**"); printManyChar(' ', width - 4); printf("**\n");
  printf("**"); printManyChar(' ', width - 4); printf("**\n");
  printf("**"); printManyChar(' ', leftPad); printf("%s", text); printManyChar(' ', rightPad); printf("**\n");
  printf("**"); printManyChar(' ', width - 4); printf("**\n");
  printf("**"); printManyChar(' ', width - 4); printf("**\n");
  stars(width); printf("\n");
  stars(width); printf("\n\n\n");
}

