#ifndef BLACK_BOX_OPTIMAL_MAXTERM_H
#define BLACK_BOX_OPTIMAL_MAXTERM_H
#include "black_box_ciphers.h"
#include "bitslice_utils.h"

int optimalBitSetStored(bbCipher cipher, int keyBitsAllowed, int ivBitsAllowed);
void getOptimalBitSet(bbCipher cipher, int *numKeyBits, int *keyBit, int *numIvBits, int *ivBit);

void blackBoxOptimalMaxtermDistinguisher(bbCipher cipher, int numBits, int keyFill, int *numKeyBits, int *keyBit, int ivFill, int *numIvBits, int *ivBit, int output, int numParallellBits);

void blackBoxOptimalMaxtermDistinguisherSurvey(bbCipher cipher, int numBits, int numParallellBits);
void blackBoxOptimalMaxtermDistinguisherSurveyAll(int numBits, int numParallellBits);

void blackBoxOptimalBitFlipSet(bbCipher cipher, int numBits, int okToUseKeyBits, int okToUseIvBits);
void blackBoxOptimalBitFlipSetAll(int numBits, int okToUseKeyBits, int okToUseIvBits);

#endif

