#ifndef BLACK_BOX_GREEDY_MAXTERM_H
#define BLACK_BOX_GREEDY_MAXTERM_H
#include "black_box_ciphers.h"
#include "fill_utils.h"

int greedyBitSetStored(bbCipher cipher, int keyBitsAllowed, int ivBitsAllowed);
void getGreedyBitSet(bbCipher cipher, int *numKeyBits, int *keyBit, int *numIvBits, int *ivBit);

#define GREEDY_STRATEGY_ADD_1 1
#define GREEDY_STRATEGY_ADD_2 2
#define GREEDY_STRATEGY_ADD_3 3
void blackBoxGreedyMaxtermDistinguisher(bbCipher cipher, const char *logFileName, const char *texFileName, int numBits, int keyFill, int ivFill, int sizeOfStartingOptimalSet, int okToUseKeyBits, int okToUseIvBits, int strategy, int numParallellBits);
void blackBoxGreedyMaxtermDistinguisherAll(int numBits, int keyFill, int ivFill, int optimalSetSize, int okToUseKeyBits, int okToUseIvBits, int strategy, int numParallellBits);

#endif

