#ifndef BLACK_BOX_GRAIN_H
#define BLACK_BOX_GRAIN_H
#include "platform_types.h"

void getBlackBoxGrainV1Info(int *keySizeInBytes, int *ivSizeInBytes, int *suppressedBytes, int *implicitBlockSizeInBytes);
int blackBoxGrainV1Encryption(const BYTE *key, const BYTE *iv, const BYTE *inBuf, unsigned int numInputBytes, BYTE *outBuf, unsigned int numOutputBytes, int withInitRoundOutput);

void getBlackBoxGrain128Info(int *keySizeInBytes, int *ivSizeInBytes, int *suppressedBytes, int *implicitBlockSizeInBytes);
int blackBoxGrain128Encryption(const BYTE *key, const BYTE *iv, const BYTE *inBuf, unsigned int numInputBytes, BYTE *outBuf, unsigned int numOutputBytes, int withInitRoundOutput);

void getBlackBoxBitslicedGrain128Info(int *keySizeInBits, int *ivSizeInBits, int *suppressedBits, int *implicitBlockSizeInBits);
int blackBoxGrain128EncryptionBitsliced(const UINT64 *key, const UINT64 *iv, const UINT64 *inBuf, unsigned int numInputBits, UINT64 *outBuf, unsigned int numOutputBits, int withInitRoundOutput);

#endif

