#ifndef BLACK_BOX_CIPHERS_H
#define BLACK_BOX_CIPHERS_H
#include "black_box_api.h"

typedef enum {
  kTrivium,
  kRabbit,
  kEdon80,
  kAES128,
  kAES256,
  kDES,
  kGrain128,
  kGrainV1,
  kTEA,
  kXTEA,
  kSEED,
  kPRESENT,
  kSMS4,
  kCamellia,
  kRC5,
  kRC6,
  kHIGHT,
//  kCLEFIA,
  kHC128,
  kHC256,
  kMickeyV2,
  kSalsa2012,
  kSOSEMANUK,
  kNumBlackBoxCiphers
} bbCipher;

typedef enum {
  kStreamCipher,
  kBlockCipher
} bbCipherType;

/* cipher name */
const char *blackBoxCipherName(bbCipher);

/* cipher type */
const bbCipherType blackBoxCipherType(bbCipher);

/* implementation variants */
int blackBoxCipherProvidesStandardImplementation(bbCipher);
int blackBoxCipherProvidesBitslicedImplementation(bbCipher);

/* cipher information */
void blackBoxInfo(bbCipher cipher, int *keySizeInBytes, int *ivSizeInBytes, int *suppressedBytes, int *implicitBlockSizeInBytes); /* standard implementation */
void blackBoxInfoBitsliced(bbCipher cipher, int *keySizeInBits, int *ivSizeInBits, int *suppressedBits, int *implicitBlockSizeInBits); /* bitsliced implementation */

/* encryption */
int blackBoxEncrypt(bbCipher cipher, const BYTE *key, const BYTE *iv, const BYTE *inBuf, unsigned int numInputBytes, BYTE *outBuf, unsigned int numOutputBytes, int withInitRoundOutput); /* standard implementation */
int blackBoxEncryptBitsliced(bbCipher cipher, const UINT64 *key, const UINT64 *iv, const UINT64 *inBuf, unsigned int numInputBits, UINT64 *outBuf, unsigned int numOutputBits, int withInitRoundOutput); /* bitsliced implementation */

#endif

