#ifndef BLACK_BOX_BIT_SET_UTILS_H
#define BLACK_BOX_BIT_SET_UTILS_H
#include "black_box_ciphers.h"
#include <stdio.h>

void initializeBitSet(int *bitSet, int bitSetSize);
int bitSetContainsValue(const int *bitSet, int size, int value);
void logBitSet(FILE *logFile, int flags, const int *bitSet, int size);
void copyBitSet(int *bitSetDst, int *dstSize, const int *bitSetSrc, int srcSize);

int xorOverBitSet(
  bbCipher cipher,
  const BYTE *key, int numKeyBits, int *keyBit,
  const BYTE *iv, int numIvBits, int *ivBit,
  const BYTE *in, int inLen,
  BYTE *xorBuf,
  int numParallellBits);

/*
 * n is the bit set size
 * m is the size of the bit space
 */
int nextBitSet(int *i, int n, int m);

/*
 * split bit set (key + iv space or such)
 */
void initializeConnectedBitSets(int nTot, int *bitSet1, int *n1, int m1, int *bitSet2, int *n2, int m2);

int nextConnectedBitSet(int *bitSet1, int *n1, int m1, int *bitSet2, int *n2, int m2);

#endif

