#ifndef BLACK_BOX_API_H
#define BLACK_BOX_API_H

#include "platform_types.h"

/* info function */
typedef void (*bbInfoFunction)(int *keySizeInBytes, int *ivSizeInBytes, int *suppressedBytes, int *implicitBlockSizeInBytes); /* standard implementation */
typedef void (*bbInfoFunctionBitsliced)(int *keySizeInBits, int *ivSizeInBits, int *suppressedBits, int *implicitBlockSizeInBits); /* bitsliced implementation */

/* cryption function */
typedef int (*bbEncryptionFunction)(const BYTE *key, const BYTE *iv, const BYTE *inBuf, unsigned int numInputBytes, BYTE *outBuf, unsigned int numOutputBytes, int withInitRoundOutput); /* standard implementation */
typedef int (*bbEncryptionFunctionBitsliced)(const UINT64 *key, const UINT64 *iv, const UINT64 *inBuf, unsigned int numInputBits, UINT64 *outBuf, unsigned int numOutputBits, int withInitRoundOutput); /* bitsliced implementation */

#endif

