/*
 * Copyright (c) Paul Stankovski
 * Free for all non-commercial use unless this directive conflicts with
 * other applicable copyright statement(s), patent holders, laws or such.
 */
#include "bittwiddling.h"
#include <string.h>

int isPowerOfTwo(UINT64 v) { return !(v & (v - 1)); }

unsigned int lg(UINT64 v) {
  unsigned int l = 0;
  while (v >>= 1)
    l++;
  return l;
}

unsigned int weight(UINT64 v) {
#if 1 /* fast for low weight v */
if (!v) return 0;
if (!(v &= v - 1)) return 1;
if (!(v &= v - 1)) return 2;
if (!(v &= v - 1)) return 3;
if (!(v &= v - 1)) return 4;
if (!(v &= v - 1)) return 5;
if (!(v &= v - 1)) return 6;
if (!(v &= v - 1)) return 7;
if (!(v &= v - 1)) return 8;
if (!(v &= v - 1)) return 9;
if (!(v &= v - 1)) return 10;
if (!(v &= v - 1)) return 11;
if (!(v &= v - 1)) return 12;
if (!(v &= v - 1)) return 13;
if (!(v &= v - 1)) return 14;
if (!(v &= v - 1)) return 15;
if (!(v &= v - 1)) return 16;
if (!(v &= v - 1)) return 17;
if (!(v &= v - 1)) return 18;
if (!(v &= v - 1)) return 19;
if (!(v &= v - 1)) return 20;
if (!(v &= v - 1)) return 21;
if (!(v &= v - 1)) return 22;
if (!(v &= v - 1)) return 23;
if (!(v &= v - 1)) return 24;
if (!(v &= v - 1)) return 25;
if (!(v &= v - 1)) return 26;
if (!(v &= v - 1)) return 27;
if (!(v &= v - 1)) return 28;
if (!(v &= v - 1)) return 29;
if (!(v &= v - 1)) return 30;
if (!(v &= v - 1)) return 31;
if (!(v &= v - 1)) return 32;
if (!(v &= v - 1)) return 33;
if (!(v &= v - 1)) return 34;
if (!(v &= v - 1)) return 35;
if (!(v &= v - 1)) return 36;
if (!(v &= v - 1)) return 37;
if (!(v &= v - 1)) return 38;
if (!(v &= v - 1)) return 39;
if (!(v &= v - 1)) return 40;
if (!(v &= v - 1)) return 41;
if (!(v &= v - 1)) return 42;
if (!(v &= v - 1)) return 43;
if (!(v &= v - 1)) return 44;
if (!(v &= v - 1)) return 45;
if (!(v &= v - 1)) return 46;
if (!(v &= v - 1)) return 47;
if (!(v &= v - 1)) return 48;
if (!(v &= v - 1)) return 49;
if (!(v &= v - 1)) return 50;
if (!(v &= v - 1)) return 51;
if (!(v &= v - 1)) return 52;
if (!(v &= v - 1)) return 53;
if (!(v &= v - 1)) return 54;
if (!(v &= v - 1)) return 55;
if (!(v &= v - 1)) return 56;
if (!(v &= v - 1)) return 57;
if (!(v &= v - 1)) return 58;
if (!(v &= v - 1)) return 59;
if (!(v &= v - 1)) return 60;
if (!(v &= v - 1)) return 61;
if (!(v &= v - 1)) return 62;
if (!(v &= v - 1)) return 63;
return 64;
#else
/* TODO: parallell summation over 64 bits */
#endif
}

unsigned int bufWeight(const BYTE *buf, int n) {
  int u = n / sizeof(UINT64), r = n % sizeof(UINT64);
  int i;
  unsigned int w = 0;
  UINT64 *p = (UINT64*)buf;

  for (i=0; i<u; i++)
    w += weight(*p++);

  if (r > 0) {
    UINT64 t = 0;
    memcpy(&t, buf + n - r, r);
    w += weight(t);
  }

  return w;
}

int numInitialZeroBits(const BYTE *buf, int numBytes) {
  int n = 0;
  int i;

  if (!buf)
    return -1;

  for (i=0; i<numBytes; i++, buf++) {
    if (*buf != 0) break;
    n += 8;
  }
  if (i == numBytes) return n;
  if ((*buf) & 0x01) return n; n++;
  if ((*buf) & 0x02) return n; n++;
  if ((*buf) & 0x04) return n; n++;
  if ((*buf) & 0x08) return n; n++;
  if ((*buf) & 0x10) return n; n++;
  if ((*buf) & 0x20) return n; n++;
  if ((*buf) & 0x40) return n; n++;
  if ((*buf) & 0x80) return n; n++;
  return n;
}

int numInitialZeroBitsByBlocks(const BYTE *buf, int numBytes, int blockSize) {
  int i, n = 0;
  const int numBlocks = numBytes / blockSize;

  if (!buf) return -1;

  for (i=0; i<numBlocks; i++) {
    int w = (int)bufWeight(buf, blockSize);
    n += blockSize * 8 - w;
    if (w) return n;
    buf += blockSize;
  }

  return n;
}

int getBufBit(const BYTE *buf, int bit) {
//  return buf[bit / 8] & (1 << (bit & 7));
//  return (buf[bit / 8] & (1 << (bit & 7))) >> (bit & 7);
  return (buf[bit / 8] >> (bit & 7)) & 1;
}

void setBufBit(BYTE *buf, int bit, int value) {
  if (value)
    buf[bit / 8] |= (BYTE)(1 << (bit & 7));
  else
    buf[bit / 8] &= (BYTE)(0xFF ^ (1 << (bit & 7)));
}

void flipBufBit(BYTE *buf, int bit) {
  buf[bit / 8] ^= (BYTE)(1 << (bit & 7));
}









#if 0
#endif
#if 0 /* for measuring the performance of weight */
#include "rdtsc.h"
UINT64 timing2(int bits) {
  UINT64 c1, c2;
  long i;
  UINT64 min = 1000000;
  UINT64 term = bits == 0 ? 0 : bits == 64 ? 0xFFFFFFFFFFFFFFFF : ((UINT64)1 << bits) - 1;

  for (i=0; i<WARMUP_ROUNDS+N; i++) {
    UINT64 c1, c2, diff;
    c1 = rdtsc();
    weight(term);
    c2 = rdtsc();
    if (i >= WARMUP_ROUNDS) {
      if (c1 < c2) { /* the expected case */
        diff = c2 - c1;
        if (diff < min) min = diff;
      }
    }
  }
  return min - 10;
}

void timing3(void) {
  int i;

  printf("Bits in word   Execution time of weight in cycles\n\n");
  for (i=0; i<65; i++)
    printf("%7d %24Ld\n", i, timing2(i));
}
#endif
