#ifndef BITSLICE_UTILS_H
#define BITSLICE_UTILS_H
#include "platform_types.h"
#include "log_utils.h"
#include "fill_utils.h"

void toBitslicedKeyIv(UINT64 *key, int keySizeInBits, const BYTE *key8,
                      UINT64 *iv, int ivSizeInBits, const BYTE *iv8,
                      int *keyBit, int numKeyBits,
                      int *ivBit, int numIvBits,
                      int *numBitsclicedKeyBits,
                      int *numBitsclicedIvBits);

void initializeBitslicedKeyValues(UINT64 *key, int keyLengthInBits, int keyFill, const BYTE *explicitKeyFill); /* obsolete, use toBitslicedKeyIv instead */
void initializeBitslicedIvValues(UINT64 *iv, int ivLengthInBits, const int *ivBit, int ivFill, const BYTE *explicitIvFill, const UINT64 *key); /* obsolete, use toBitslicedKeyIv instead */

void fromBitslicedBufByWeight(BYTE *dst, const UINT64 *src, int numBits);
void fromBitslicedBufByLSB(BYTE *dst, const UINT64 *src, int numBits);
void toBitslicedBuf(UINT64 *dst, const BYTE *src, int numBits);

void logBitslicedBufByWeight(FILE *logFile, const UINT64 *buf, int len, int gap);
void logBitslicedBufByLSB(FILE *logFile, const UINT64 *buf, int len, int gap);

void setKeyBits(UINT64 *key, UINT64 j, int numKeyBits, const int *keyBit, int numBitsliceBits);
void setIvBits(UINT64 *iv, UINT64 i, int numIvBits, const int *ivBit, int numBitsliceBits);

#endif

