#ifndef ASSERT_UTILS_H
#define ASSERT_UTILS_H
#ifdef _DEBUG
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "press_any_key.h"

#define CODE_BODY(message) \
  char *file = strrchr((const char *)__FILE__, '\\'); \
  printf("Assert triggered on line %d in file %s: %s\n", __LINE__, file ? (file + 1) : __FILE__, message); \
  pressAnyKey(); \
  exit(EXIT_FAILURE);

#define ASSERT(condition, message) \
  do { \
    if (!(condition)) { \
      CODE_BODY(message) \
    } \
  } while(0)

#define ASSERT_ALWAYS(message) \
  do { \
      CODE_BODY(message) \
  } while(0)

#else

#define ASSERT(condition, message)

#define ASSERT_ALWAYS(message)

#endif

#endif

