
c = 3e8;                                    % Speed of light m/s
f_base = 15000;                             % 15 kHz

%--------------------------------------------------------------------------
% you should put your values
%--------------------------------------------------------------------------
fc = 2.6e9;                                 % Carrier frequence in Hz
% information comes from the PCI table (you should put your values)
mu = 2;                                     % Numerology
N_RB = 70;                                  % Number of Resource Blocks
%--------------------------------------------------------------------------
% calculation of the number of subcarriers and subframe separation
N_sub = 12*N_RB;                            % Number of subcarriers, each resource block has 12 subcarriers
f_sub = 2^mu*f_base;                        % Subcarriers separation

% We consider a simple case where all subcarriers are located from the
% right side of the fc (carrier frequency): f_i = fc + i*f_sub, i in [1, N_sub].
f_vec = fc + (1:N_sub)'*f_sub;              % Subcarriers frequencies 
l_vec = c*(1./f_vec);                       % Wavelength each subcarriers


%--------------------------------------------------------------------------
% Your code is here - you should calulcate power of signal and noise properly
%--------------------------------------------------------------------------
% Power density of noise
PDN = -174;                                 % Power density of noise in dBm/Hz
Pn_per_herz = xxx;                          % noise power in watts per herz

% Signal power
Ps = 20*10^(-3);                            % in Watts (20mW)
Ps_per_herz = xxx;                          % signal power in watts per hertz

% SNR of the transmitted signal to the given noise
TxS2NF_ratio = Ps_per_herz/Pn_per_herz;
%--------------------------------------------------------------------------


%--------------------------------------------------------------------------
% Your code is here - you should calulcate the propagation paths
%--------------------------------------------------------------------------
% The information comes from the multipath environment
% d1 = 300;                                   % covered distance #1
% d2 = 320;                                   % covered distance #2
% time delay for each path
tau1 = d1/c;
tau2 = d2/c;


%--------------------------------------------------------------------------
% channel calculation
%--------------------------------------------------------------------------
C1 = 0.5; % attenuation caused by the polarization change and reflection
FSL1 = l_vec/(4*pi*d1);                     % Free space loss
Exp1 = exp(-1j*2*pi*(f_vec)*tau1);          % Signal's phase rotation
Path1 = C1 * FSL1.*Exp1;

C2 = 0.5; % attenuation caused by the polarization change and reflection
FSL2 = l_vec/(4*pi*d2);                     % Free space loss
Exp2 = exp(-1j*2*pi*(f_vec)*tau2);          % Signal's phase rotation
Path2 = C2 * FSL2.*Exp2;

H = Path1 + Path2;                          % total channel
%--------------------------------------------------------------------------


%--------------------------------------------------------------------------
% Your code is here - you should calulcate the SNR
%--------------------------------------------------------------------------
SNR = xxx;

figure                                      % draw the power shape
plot(SNR,'-o')                              % SNR for multipath case
