import java.util.*;
import java.io.*;

//Denna klass rver Proc, det gr att man kan anvnda time och signalnamn utan punktnotation

class Gen extends Proc{

	//Slumptalsgeneratorn startas:
	Random slump = new Random();
	
	QS queues[] = new QS[5];
	int queueNbr = 0;

	//Generatorn har tv parametrar:
	public Proc sendTo;    //Anger till vilken process de genererade kunderna ska skickas
	public double lambda;  //Hur mnga per sekund som ska generas
	
	private Proc randomQueue(){
		int i = slump.nextInt(5);
		return queues[i];
	}
		
	private Proc roundRobin(){
		queueNbr++;
		if (queueNbr == 5) queueNbr = 0;
		return queues[queueNbr];
	}
	
	private Proc smallest(){
		int smallestFound = queues[0].numberInQueue;
		int smallestIndex = 0;
		for (int i = 1; i < 5; i++){
			if (smallestFound > queues[i].numberInQueue){
				smallestFound = queues[i].numberInQueue;
				smallestIndex = i;
			}
		}
		return queues[smallestIndex];
	}
		
	private Proc smallestWithDelay(){
		int smallestFound = queues[0].antal;
		int smallestIndex = 0;
		for (int i = 1; i < 5; i++){
			if (smallestFound > queues[i].antal){
				smallestFound = queues[i].antal;
				smallestIndex = i;
			}
		}
		return queues[smallestIndex];
	}

	//Hr nedan anger man vad som ska gras nr en signal kommer
	public void TreatSignal(Signal x){
		switch (x.signalType){
			case READY:{
				SendSignal(ARRIVAL, roundRobin(), 0);
				SendSignal(READY, this, (2.0/lambda)*slump.nextDouble());}
				break;
		}
	}
}